
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MESS_IO.H - Message Data Access Function Prototypes (NavCore family)
// 
//
//   DESCRIPTION
//
//   Prototypes for the functions used to store and retrieve data from NavCore
//   receiver messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Include\Archives\MESS_IO.H_V  $
//   
//      Rev 1.15   06 Nov 1998 17:47:20   phungh
//   Labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the write to file code
//   portion out of the interrupt hander so that
//   data is not missed because of time spent
//   too long in the interrupt handler.
//   
//      Rev 1.3   Jul 09 1997 10:27:30   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:04:40   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:25:32   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:54:26   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

short  get_cs     ( unsigned char *, short );
float  get_F24    ( short );
double get_F40    ( short );
short  get_I16    ( short );
long   get_I32    ( short );
void   make_short (short value ,unsigned char *tx_buff, short offset);
void   make_long  (long value ,unsigned char *tx_buff, short offset);
void   make_F24   (double, unsigned char *, short);
void   make_F40   (double, unsigned char *, short);
